/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.template;

import br.gov.frameworkdemoiselle.pagination.Pagination;
import br.gov.frameworkdemoiselle.pagination.PaginationContext;
import br.gov.frameworkdemoiselle.template.AbstractPageBean;
import br.gov.frameworkdemoiselle.template.ListPageBean;
import br.gov.frameworkdemoiselle.util.Reflections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.inject.Inject;

public abstract class AbstractListPageBean<T, I>
extends AbstractPageBean
implements ListPageBean<T, I> {
    private static final long serialVersionUID = 1L;
    private List<T> resultList;
    private transient DataModel<T> dataModel;
    private Map<I, Boolean> selection = new HashMap<I, Boolean>();
    @Inject
    private PaginationContext paginationContext;
    private Class<T> beanClass;

    public void clear() {
        this.dataModel = null;
        this.resultList = null;
    }

    protected Class<T> getBeanClass() {
        if (this.beanClass == null) {
            this.beanClass = Reflections.getGenericTypeArgument(this.getClass(), (int)0);
        }
        return this.beanClass;
    }

    @Override
    public DataModel<T> getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListDataModel(this.getResultList());
        }
        return this.dataModel;
    }

    @Override
    public List<T> getResultList() {
        if (this.resultList == null) {
            this.resultList = this.handleResultList();
        }
        return this.resultList;
    }

    protected abstract List<T> handleResultList();

    @Override
    public String list() {
        this.clear();
        return this.getCurrentView();
    }

    @Override
    public Map<I, Boolean> getSelection() {
        return this.selection;
    }

    @Override
    public void setSelection(Map<I, Boolean> selection) {
        this.selection = selection;
    }

    public void clearSelection() {
        this.selection = new HashMap<I, Boolean>();
    }

    public List<I> getSelectedList() {
        ArrayList<I> selectedList = new ArrayList<I>();
        for (I id : this.getSelection().keySet()) {
            if (!this.getSelection().get(id).booleanValue()) continue;
            selectedList.add(id);
        }
        return selectedList;
    }

    public Pagination getPagination() {
        return this.paginationContext.getPagination(this.getBeanClass(), true);
    }
}

