/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.util;

import br.gov.frameworkdemoiselle.exception.ApplicationException;
import br.gov.frameworkdemoiselle.message.Message;
import br.gov.frameworkdemoiselle.message.SeverityType;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Strings;
import com.sun.faces.util.Util;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

public class Faces {
    public static void addMessages(List<Message> messages) {
        if (messages != null) {
            for (Message m : messages) {
                Faces.addMessage(m);
            }
        }
    }

    public static void addMessage(Message message) {
        Faces.getFacesContext().addMessage(null, Faces.parse(message));
    }

    public static void addMessage(String clientId, Message message) {
        Faces.getFacesContext().addMessage(clientId, Faces.parse(message));
    }

    public static void addMessage(String clientId, Throwable throwable) {
        Faces.getFacesContext().addMessage(clientId, Faces.parse(throwable));
    }

    public static void addMessage(Throwable throwable) {
        Faces.addMessage(null, throwable);
    }

    private static FacesContext getFacesContext() {
        return (FacesContext)Beans.getReference(FacesContext.class);
    }

    public static FacesMessage.Severity parse(SeverityType severityType) {
        FacesMessage.Severity result = null;
        switch (severityType) {
            case INFO: {
                result = FacesMessage.SEVERITY_INFO;
                break;
            }
            case WARN: {
                result = FacesMessage.SEVERITY_WARN;
                break;
            }
            case ERROR: {
                result = FacesMessage.SEVERITY_ERROR;
                break;
            }
            case FATAL: {
                result = FacesMessage.SEVERITY_FATAL;
            }
        }
        return result;
    }

    public static FacesMessage parse(Throwable throwable) {
        FacesMessage facesMessage = new FacesMessage();
        ApplicationException annotation = throwable.getClass().getAnnotation(ApplicationException.class);
        if (annotation != null) {
            facesMessage.setSeverity(Faces.parse(annotation.severity()));
        } else {
            facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
        }
        if (throwable.getMessage() != null) {
            facesMessage.setSummary(throwable.getMessage());
        } else {
            facesMessage.setSummary(throwable.toString());
        }
        return facesMessage;
    }

    public static FacesMessage parse(Message message) {
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSeverity(Faces.parse(message.getSeverity()));
        facesMessage.setSummary(message.getText());
        return facesMessage;
    }

    public static Object convert(String value, Converter converter) {
        Object result = null;
        if (!Strings.isEmpty((String)value)) {
            result = converter != null ? converter.getAsObject(Faces.getFacesContext(), (UIComponent)Faces.getFacesContext().getViewRoot(), value) : new String(value);
        }
        return result;
    }

    public static Converter getConverter(Class<?> clazz) {
        return Util.getConverterForClass(clazz, (FacesContext)Faces.getFacesContext());
    }

    public static Map<String, Object> getViewMap() {
        UIViewRoot viewRoot = Faces.getFacesContext().getViewRoot();
        return viewRoot.getViewMap(true);
    }
}

