/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.util.Beans;
import java.io.Serializable;
import java.util.Locale;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;

@SessionScoped
@Alternative
public class JsfLocaleProducer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean loaded = false;

    @Produces
    @Default
    @Named(value="currentLocale")
    public Locale create() {
        Locale locale;
        try {
            FacesContext facesContext = (FacesContext)Beans.getReference(FacesContext.class);
            if (!this.loaded) {
                if (facesContext != null) {
                    HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
                    locale = request.getLocale();
                    facesContext.getApplication().setDefaultLocale(locale);
                }
                this.loaded = true;
            }
            locale = facesContext.getApplication().getDefaultLocale();
        }
        catch (ContextNotActiveException cause) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

