/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.internal.configuration.JsfSecurityConfig;
import br.gov.frameworkdemoiselle.security.AfterLoginSuccessful;
import br.gov.frameworkdemoiselle.security.AfterLogoutSuccessful;
import br.gov.frameworkdemoiselle.util.PageNotFoundException;
import br.gov.frameworkdemoiselle.util.Redirector;
import com.sun.faces.config.ConfigurationException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;

@SessionScoped
public class SecurityObserver
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private FacesContext facesContext;
    @Inject
    private JsfSecurityConfig config;
    @Inject
    private HttpSession session;
    private Map<String, Object> savedParams = new HashMap<String, Object>();
    private String savedViewId;
    @Inject
    private Logger logger;

    public SecurityObserver() {
        this.clear();
    }

    private void saveCurrentState() {
        this.clear();
        if (!this.config.getLoginPage().equals(this.facesContext.getViewRoot().getViewId())) {
            this.savedParams.putAll(this.facesContext.getExternalContext().getRequestParameterMap());
            this.savedViewId = this.facesContext.getViewRoot().getViewId();
        }
    }

    public void redirectToLoginPage() {
        this.saveCurrentState();
        try {
            Redirector.redirect(this.config.getLoginPage());
        }
        catch (PageNotFoundException cause) {
            throw new ConfigurationException("A tela de login \"" + cause.getViewId() + "\" n\u00e3o foi encontrada. Caso o seu projeto possua outra, defina no arquivo de configura\u00e7\u00e3o a chave \"" + "frameworkdemoiselle.security.login.page" + "\"", (Throwable)((Object)cause));
        }
    }

    public void onLoginSuccessful(@Observes AfterLoginSuccessful event) {
        boolean redirectedFromConfig = false;
        try {
            if (this.savedViewId != null) {
                Redirector.redirect(this.savedViewId, this.savedParams);
            } else if (this.config.isRedirectEnabled()) {
                redirectedFromConfig = true;
                Redirector.redirect(this.config.getRedirectAfterLogin(), this.savedParams);
            }
        }
        catch (PageNotFoundException cause) {
            if (redirectedFromConfig) {
                throw new ConfigurationException("A tela \"" + cause.getViewId() + "\" que \u00e9 invocada ap\u00f3s o logon n\u00e3o foi encontrada. Caso o seu projeto possua outra, defina no arquivo de configura\u00e7\u00e3o a chave \"" + "frameworkdemoiselle.security.redirect.after.login" + "\"", (Throwable)((Object)cause));
            }
            throw cause;
        }
        finally {
            this.clear();
        }
    }

    public void onLogoutSuccessful(@Observes AfterLogoutSuccessful event) {
        try {
            if (this.config.isRedirectEnabled()) {
                Redirector.redirect(this.config.getRedirectAfterLogout());
            }
        }
        catch (PageNotFoundException cause) {
            throw new ConfigurationException("A tela \"" + cause.getViewId() + "\" que \u00e9 invocada ap\u00f3s o logout n\u00e3o foi encontrada. Caso o seu projeto possua outra, defina no arquivo de configura\u00e7\u00e3o a chave \"" + "frameworkdemoiselle.security.redirect.after.logout" + "\"", (Throwable)((Object)cause));
        }
        finally {
            try {
                this.session.invalidate();
            }
            catch (IllegalStateException e) {
                this.logger.debug("Esta sess\u00e3o j\u00e1 foi invalidada.");
            }
        }
    }

    private void clear() {
        this.savedViewId = null;
        this.savedParams.clear();
    }
}

