/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.annotation.ViewScoped;
import br.gov.frameworkdemoiselle.util.Faces;
import br.gov.frameworkdemoiselle.util.Parameter;
import br.gov.frameworkdemoiselle.util.Reflections;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.faces.convert.Converter;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;

public class ParameterImpl<T>
implements Parameter<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Class<Object> type;
    private Converter converter;
    private final InjectionPoint ip;
    private final HttpServletRequest request;
    private T value;
    private final String key;

    @Inject
    public ParameterImpl(InjectionPoint ip, HttpServletRequest request) {
        this.ip = ip;
        this.request = request;
        this.key = ip.getAnnotated().isAnnotationPresent(Name.class) ? ((Name)ip.getAnnotated().getAnnotation(Name.class)).value() : ip.getMember().getName();
        this.type = Reflections.getGenericTypeArgument((Member)ip.getMember(), (int)0);
        this.converter = Faces.getConverter(this.type);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    private boolean isSessionScoped() {
        return this.ip.getAnnotated().isAnnotationPresent(SessionScoped.class);
    }

    private boolean isViewScoped() {
        return this.ip.getAnnotated().isAnnotationPresent(ViewScoped.class);
    }

    private boolean isRequestScoped() {
        return this.ip.getAnnotated().isAnnotationPresent(RequestScoped.class);
    }

    @Override
    public T getValue() {
        Object result = null;
        String parameterValue = this.request.getParameter(this.key);
        if (this.isSessionScoped()) {
            if (parameterValue != null) {
                this.request.getSession().setAttribute(this.key, Faces.convert(parameterValue, this.converter));
            }
            result = this.request.getSession().getAttribute(this.key);
        } else if (this.isRequestScoped()) {
            result = Faces.convert(parameterValue, this.converter);
        } else if (this.isViewScoped()) {
            Map<String, Object> viewMap = Faces.getViewMap();
            if (parameterValue != null) {
                viewMap.put(this.key, Faces.convert(parameterValue, this.converter));
            }
            result = viewMap.get(this.key);
        } else {
            if (this.value == null) {
                this.value = Faces.convert(parameterValue, this.converter);
            }
            result = this.value;
        }
        return (T)result;
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    @Override
    public void setValue(T value) {
        if (this.isSessionScoped()) {
            this.request.getSession().setAttribute(this.key, value);
        } else if (!this.isRequestScoped()) {
            if (this.isViewScoped()) {
                Map<String, Object> viewMap = Faces.getViewMap();
                viewMap.put(this.key, value);
            } else {
                this.value = value;
            }
        }
    }
}

