/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.util.Faces;
import br.gov.frameworkdemoiselle.util.FileRenderer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class FileRendererImpl
implements FileRenderer {
    private static final long serialVersionUID = 7787266586182058798L;
    @Inject
    private HttpServletResponse response;
    @Inject
    private Logger logger;
    @Inject
    private FacesContext context;

    @Override
    public void render(byte[] byteArray, FileRenderer.ContentType contentType, String fileName) {
        this.logger.debug("Renderizando para o arquivo " + fileName + ".");
        try {
            this.response.setContentType(contentType.getContentType());
            this.response.setContentLength(byteArray.length);
            this.response.setHeader("Content-Disposition", "filename=\"" + fileName + "\"");
            this.logger.debug("Escrevendo o arquivo " + fileName + " no response.");
            this.response.getOutputStream().write(byteArray, 0, byteArray.length);
            this.response.getOutputStream().flush();
            this.response.getOutputStream().close();
        }
        catch (IOException e) {
            this.logger.info("Erro na gera\u00e7\u00e3o do relat\u00f3rio. Inclu\u00edndo a exce\u00e7\u00e3o de erro em um FacesMessage", (Throwable)e);
            Faces.addMessage(e);
        }
        this.context.responseComplete();
    }

    @Override
    public void render(InputStream stream, FileRenderer.ContentType contentType, String fileName) {
        this.logger.debug("Renderizando o arquivo " + fileName + ".");
        this.render(this.getBytes(stream), contentType, fileName);
    }

    @Override
    public void render(File file, FileRenderer.ContentType contentType, String fileName) {
        this.logger.debug("Renderizando para o arquivo " + fileName + ".");
        try {
            this.render(new FileInputStream(file), contentType, fileName);
        }
        catch (FileNotFoundException e) {
            this.logger.info("Erro na gera\u00e7\u00e3o do relat\u00f3rio. Inclu\u00edndo a exce\u00e7\u00e3o de erro em um FacesMessage", (Throwable)e);
            Faces.addMessage(e);
        }
    }

    private byte[] getBytes(InputStream stream) {
        byte[] byteArray = null;
        try {
            int thisLine;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((thisLine = stream.read()) != -1) {
                bos.write(thisLine);
            }
            bos.flush();
            byteArray = bos.toByteArray();
            if (bos != null) {
                bos.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return byteArray;
    }
}

