/*
 * Demoiselle Framework
 * Copyright (C) 2010 SERPRO
 * ----------------------------------------------------------------------------
 * This file is part of Demoiselle Framework.
 * 
 * Demoiselle Framework is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License version 3
 * along with this program; if not,  see <http://www.gnu.org/licenses/>
 * or write to the Free Software Foundation, Inc., 51 Franklin Street,
 * Fifth Floor, Boston, MA  02110-1301, USA.
 * ----------------------------------------------------------------------------
 * Este arquivo é parte do Framework Demoiselle.
 * 
 * O Framework Demoiselle é um software livre; você pode redistribuí-lo e/ou
 * modificá-lo dentro dos termos da GNU LGPL versão 3 como publicada pela Fundação
 * do Software Livre (FSF).
 * 
 * Este programa é distribuído na esperança que possa ser útil, mas SEM NENHUMA
 * GARANTIA; sem uma garantia implícita de ADEQUAÇÃO a qualquer MERCADO ou
 * APLICAÇÃO EM PARTICULAR. Veja a Licença Pública Geral GNU/LGPL em português
 * para maiores detalhes.
 * 
 * Você deve ter recebido uma cópia da GNU LGPL versão 3, sob o título
 * "LICENCA.txt", junto com esse programa. Se não, acesse <http://www.gnu.org/licenses/>
 * ou escreva para a Fundação do Software Livre (FSF) Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02111-1301, USA.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

import org.slf4j.Logger;

import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.message.MessageContext;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Faces;

/**
 * This class is a JSF phase listener intended to transfer messages from Demoiselle Context to JSF own context.
 * 
 * @author SERPRO
 */
public class MessagePhaseListener implements PhaseListener {

	private static final long serialVersionUID = 1L;

	// FIXME: por que não funciona injeção disso aqui?
	// @Inject
	// private Logger logger;
	private final Logger logger = LoggerProducer.create(this.getClass());

	// TODO: usar o bundle nas mensagens de log
	// @Inject
	// @Name("demoiselle-core-bundle")
	// private ResourceBundle bundle;

	public void beforePhase(PhaseEvent e) {
		transferMessages(e);
	}

	public void afterPhase(PhaseEvent e) {
	}

	/**
	 * Transfers messages from a context to another.
	 * 
	 * @param e
	 *            PhaseEvent
	 */
	private void transferMessages(PhaseEvent e) {

		logger.debug(this.getClass().getSimpleName() + " " + e.getPhaseId());

		MessageContext messageContext = Beans.getReference(MessageContext.class);

		logger.debug("Moving " + messageContext.getMessages().size()
				+ " message(s) from MessageContext to FacesContext.");

		Faces.addMessages(messageContext.getMessages());
		messageContext.clear();
	}

	public PhaseId getPhaseId() {
		return PhaseId.RENDER_RESPONSE;
	}

}
