/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.certificate.criptography;

public enum SymmetricAlgorithmEnum {
    TRI_DES("DESede", "DESede/ECB/PKCS5Padding", 112),
    AES("AES", "AES/ECB/PKCS5Padding", 128);

    public static SymmetricAlgorithmEnum DEFAULT;
    private String keyAlgorithm;
    private String algorithm;
    private int size;

    static {
        DEFAULT = AES;
    }

    private SymmetricAlgorithmEnum(String keyAlgorithm, String algorithm, int size) {
        this.keyAlgorithm = keyAlgorithm;
        this.algorithm = algorithm;
        this.size = size;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public int getSize() {
        return this.size;
    }

    public static SymmetricAlgorithmEnum getSymmetricAlgorithm(String algorithm) {
        SymmetricAlgorithmEnum[] symmetricAlgorithmEnumArray = SymmetricAlgorithmEnum.values();
        int n = symmetricAlgorithmEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SymmetricAlgorithmEnum value = symmetricAlgorithmEnumArray[n2];
            if (value.getAlgorithm().equalsIgnoreCase(algorithm)) {
                return value;
            }
            ++n2;
        }
        return null;
    }
}

