/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.certificate.criptography;

public enum DigestAlgorithmEnum {
    SHA_1("SHA-1"),
    SHA_256("SHA-256"),
    SHA_512("SHA-512"),
    MD5("MD5");

    public static DigestAlgorithmEnum DEFAULT;
    private String algorithm;

    static {
        DEFAULT = SHA_1;
    }

    private DigestAlgorithmEnum(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static DigestAlgorithmEnum getDigestAlgorithmEnum(String algorithm) {
        DigestAlgorithmEnum[] digestAlgorithmEnumArray = DigestAlgorithmEnum.values();
        int n = digestAlgorithmEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            DigestAlgorithmEnum value = digestAlgorithmEnumArray[n2];
            if (value.getAlgorithm().equalsIgnoreCase(algorithm)) {
                return value;
            }
            ++n2;
        }
        return null;
    }
}

