/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.certificate.criptography;

public enum AsymmetricAlgorithmEnum {
    RSA("RSA/ECB/PKCS1Padding"),
    ECDSA("ECDSA");

    public static AsymmetricAlgorithmEnum DEFAULT;
    private String algorithm;

    static {
        DEFAULT = RSA;
    }

    private AsymmetricAlgorithmEnum(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static AsymmetricAlgorithmEnum getAsymmetricAlgorithmEnum(String algorithm) {
        AsymmetricAlgorithmEnum[] asymmetricAlgorithmEnumArray = AsymmetricAlgorithmEnum.values();
        int n = asymmetricAlgorithmEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            AsymmetricAlgorithmEnum value = asymmetricAlgorithmEnumArray[n2];
            if (value.getAlgorithm().equalsIgnoreCase(algorithm)) {
                return value;
            }
            ++n2;
        }
        return null;
    }
}

